/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items;

import com.fej1fun.potentials.energy.ItemEnergyStorage;
import com.fej1fun.potentials.energy.UniversalEnergyStorage;
import com.fej1fun.potentials.providers.EnergyProvider;
import com.st0x0ef.stellaris.common.blocks.machines.PowerBankBlock;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class PowerBankItem
extends BlockItem
implements EnergyProvider.ITEM {
    final int capacity;

    public PowerBankItem(PowerBankBlock block, Item.Properties properties) {
        super((Block)block, properties);
        this.capacity = (int)Math.pow(2.0, 4 * block.tier) * 1000;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        UniversalEnergyStorage energy = this.getEnergy(stack);
        tooltipComponents.add((Component)Component.literal((String)(energy.getEnergy() + " / " + energy.getMaxEnergy() + "FE")).withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    public UniversalEnergyStorage getEnergy(@NotNull ItemStack stack) {
        return new ItemEnergyStorage(stack, (DataComponentType)DataComponentsRegistry.ENERGY.get(), this.capacity, this.capacity / 8, this.capacity / 8);
    }
}

